#rem 4-digit Portable Display.bas 
This is a hand-held 4-digit white 7-segment LED display receiving data from the 
Mobile Logger, the Solar Transmitter.or the Alpha LED Clock
as selected on switch-on.
John Saunders
8/13/2018
#endrem
#picaxe 14M2
SETFREQ M8
symbol DispRx	   	 = C.2
symbol ButtonLeft 	 = pinC.0
symbol ButtonRight	 = pinC.4
symbol VoltPort	       = B.2
symbol Int_Port	       = pinC.1
symbol Rcvr_In    	 = B.3

rem variables
symbol LeftSwVal	  	= bit0
symbol RightSwVal		= bit1
symbol NewModeFlag	= bit2
symbol BattVolt 	   	= w13
symbol Scratch	     	= b1
symbol Iter 		= b2
symbol TableAddress	= b3		'A DATA address containing a DATA address
symbol DataAddress   	= b4		'A DATA address containing an ID character

rem global variables
symbol DPCode     	= b6		'Code for displaying decimal points:0=none,1=x.xxx,2=xx.xx,4=xxx.x,4=colon in middle
symbol Mode			= b7		'The source device: 0="s"=Solar Transmitter,1="t"=Alpha LED Clock,2="w"=Mobile Logger
symbol Field        	= b8		'The message field being displayed. 

rem interrupt variables
symbol FieldAddress     = b10 	'A memory address containing data
symbol I_tmp      	= b11
symbol CheckHex    	= b12
symbol MemAddress		= b13		'A received memory address
symbol Msg_End    	= b14		'Memory address of last data character (=length code + 43)
symbol CheckSum    	= b15
symbol StoreAddress	= b16

#rem
Master formatting tables for ID display
The first is the Mode ID character to go in the first digit
Each field has 2 values: for the characters in digits 3 & 4, 
#endrem
DATA   0,(0x6D,0x63,0x71,0x76,0x3E,0x39,0x3E,0x6D,0x73)	'Solar Transmitter, Mode = 0, Key = "s", ID = "S"
DATA  10,(0x39,0x5E,0x77,0x07,0x31,0x5E,0x77,0x07,0x31)	'Alpha LED Clock    Mode = 1, Key = "t", ID = "C"
DATA  20,(0x38,0X77,0X38,0x63,0x71,0x76,0x3E,0x6D,0x73)	'Mobsile Logger     Mode = 2, Key = "w", ID = "L"

#rem
Master formatting tables for Data display, 4 fields of 5 bytes each
First is the decimal point code which is bit-mapped 
The rest are the memory addresses for the 4 digits the Mode ID character to go in the first digit
#endrem
DATA  30,(0, 28,104,105,106,0, 28,108,109,110,0, 28,112,113,114,0, 28,116,117,118)	'Solar Transmitter, Mode = 0, Key = "s", ID = "S"
DATA  50,(2,104,105,107,108,8,110,111,113,114,2,104,105,107,108,4,110,111,113,114)	'Alpha LED Clock    Mode = 1, Key = "t", ID = "C"
DATA  70,(0,104,105,106,107,4,109,110,111,112,4,114,115,117,117,1,119,120,121,122)	'Mobsile Logger     Mode = 2, Key = "w", ID = "L"

#rem Memory mapping by field
field:             0          1          2          3
"s" Name      Temperature   Humidity   Current     Voltage
"s" Format	   " ",xxx    " ",xxx    " ",xxx     " ",x.xx
"s" Address      30-32      32-34     35-37         38-40         
"t" Name        Month        Date       Hour        Minute 
"t" Format            xx.xx                  xx:xx
"t" Address      30-31       32-33      34-35       36-37
"w" Name      Altitude   Temperature  Humidity     Voltage
"w" Format      xxxx        xxx.x       xxx.x       xx.xx
"w" Address      30-33      34-37       38-41       42-45
Display Battery:
Battery Format				" ",x.xx
Battery Address   			46-49
Interrupt mapping: 210-255
#endrem 


init:
SETFREQ m8
LET Field = 1
LET NewModeFlag=1
LET Mode = 2
POKE 28,0				'Mobile Logger
LET LeftSwVal =  ButtonLeft
LET RightSwVal =  ButtonRight
IF LeftSwVal = 0 THEN
	LET Mode = 0			'Solar Transmitter
ENDIF
IF RightSwVal = 0 THEN
	LET Mode = 1			'Alpha LED Clock
ENDIF
PAUSE 100
SETINT  %00000010,%00000010    	'Interrupt when C.1 high

main:
PAUSE 100
IF NewModeFlag=1 AND Mode < 4 THEN
	SERTXD ("Mode=",#Mode,",Field=",#Field,13,10)
	GOSUB DisplayID
	DO
		LET LeftSwVal =  ButtonLeft
		LET RightSwVal =  ButtonRight
	LOOP UNTIL LeftSwVal = 1 AND RightSwVal = 1
	LET NewModeFlag = 0
ENDIF

IF Field = 4 THEN
	GOSUB GetVolts
	PAUSE 1000
ENDIF

GOSUB GetKeys

GOTO Main

GetKeys:
LET LeftSwVal =  ButtonLeft
IF LeftSwVal = 0 AND NewModeFlag=0 THEN
	IF Field > 0 THEN
		DEC Field
	ELSE
		LET Field = 4
	ENDIF
	LET NewModeFlag=1			'Show Mode ID
ENDIF

LET RightSwVal =  ButtonRight
IF NewModeFlag=0 AND RightSwVal = 0 THEN
	IF Field < 4 THEN
		INC Field
	ELSE
		LET Field = 0
	ENDIF
	LET NewModeFlag=1			'Show Mode ID
ENDIF

RETURN

GetVolts:
rem Measure and Display Battery voltage
SEROUT DispRx,T9600_8,(0X77,2,0X7B,0)
FVRSETUP FVR4096
ADCCONFIG %011
READADC10 VoltPort,BattVolt
LET BattVolt =  4 * BattVolt + 5 / 10
LET BattVolt = BattVolt // 1000
LET Scratch = BattVolt/100
SEROUT DispRx,T9600_8,(0X79,1,Scratch)
LET BattVolt = BattVolt // 100
LET Scratch = BattVolt / 10
SEROUT DispRx,T9600_8,(0X79,2,Scratch)
LET Scratch    = BattVolt // 10
SEROUT DispRx,T9600_8,(0X79,32,Scratch)
RETURN

DisplayID:
LET TableAddress = 10 * Mode				'DATA Location of Mode letter
READ TableAddress,Scratch
SETINT OFF
SEROUT DispRx,T9600_8,(0X7B,Scratch,0X7C,0)	'Mode character and A blank position					
LET DataAddress = 3 * Field + TableAddress	'Field position in Master table for field ID 
READ DataAddress,Scratch				'Position 3 character					
SEROUT DispRx,T9600_8,(0X7D,Scratch)		'Left Field ID letter
INC DataAddress
READ DataAddress,Scratch				'Right Field ID letter									
SEROUT DispRx,T9600_8,(0X7E,Scratch,0X77,0)	'and cancel decimal points	
SETINT  %00000010,%00000010    			'Interrupt when C.1 high
RETURN

DisplayField:						'Display data value on interrupt
SEROUT DispRx,T9600_8,(0X7B,0X1C)			'Briefly show symbol in left digit
PAUSE 800					
LET FieldAddress = 20 * Mode + 30			'Master table for mode 
LET FieldAddress = 5 * Field + FieldAddress	'Field position in Master table for Decimal Code
READ FieldAddress,I_tmp					'Decimal code
SEROUT DispRx,T9600_8,(0X77,I_tmp)
INC FieldAddress						'DATA address for MSB number memory location
READ FieldAddress,MemAddress				'MSB address
PEEK MemAddress,I_tmp
SEROUT DispRx,T9600_8,(0X79,0,I_tmp)
INC FieldAddress						'DATA address for MSB number memory location
READ FieldAddress,MemAddress				'Digit2 address
PEEK MemAddress,I_tmp
SEROUT DispRx,T9600_8,(0X79,1,I_tmp)INC FieldAddress						'DATA address for MSB number memory location
READ FieldAddress,MemAddress				'Digit3 address
PEEK MemAddress,I_tmp
SEROUT DispRx,T9600_8,(0X79,2,I_tmp)INC FieldAddress						'DATA address for MSB number memory location
READ FieldAddress,MemAddress				'Digit4 address
PEEK MemAddress,I_tmp
SEROUT DispRx,T9600_8,(0X79,3,I_tmp)
RETURN


Interrupt:					'Message from selected transmitter
LET bptr=100
POKE 100,"Z"
SERIN [40],Rcvr_In,N2400_8,("14L1776"),@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc, @bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc, @bptrinc,@bptrinc,@bptrinc,@bptr
LOOKUP Mode,("s","t","w"),I_tmp
PEEK 100,StoreAddress 
IF StoreAddress <> I_tmp THEN End_Interrupt			'Not the one wanted
PEEK 102, I_tmp   			'The length code, 60 + number of data bytes between commas, including commas between fields
LET Msg_End = I_tmp + 43 		'Address of last data character
IF Msg_end < 114 OR Msg_End > 122 THEN End_Interrupt			'A message length for checksum
LET Checksum = 0
FOR StoreAddress = 104 TO Msg_End
	PEEK StoreAddress,CheckHex     
	LET CheckSum = CheckSum + CheckHex
NEXT
LET CheckHex = CheckSum / 16
IF CheckHex  < 10 THEN
	LET CheckHex = CheckHex + "0"
ELSE
	LET CheckHex = CheckHex + "7"
ENDIF
LET StoreAddress = Msg_End + 2  	'Address of first checksun byte
PEEK StoreAddress,I_tmp		    	'First Checksum character
IF CheckHex <> I_tmp THEN End_Interrupt
LET CheckHex = CheckSum & $F
IF CheckHex  < 10 THEN
	LET CheckHex = Checkhex + "0"
ELSE
	LET CheckHex = CheckHex + "7"
ENDIF
LET StoreAddress = Msg_End + 3  	'Address of second checksun byte
PEEK StoreAddress,I_tmp		    	'Second Checksum character
IF CheckHex <> I_tmp THEN End_Interrupt


IF NewModeFlag = 1 OR Field = 4 THEN End_Interrupt

GOSUB DisplayField
End_Interrupt:
SETINT  %00000010,%00000010	'Interrupt when C.1 high
RETURN
